﻿'Description:
'
'Author:
'
'Plugin Creation Date:
'__/__/____
'Version Number:
'0.0.1
'Template Created by Mr ChriZ
#Region "Library Imports"
Imports System.Runtime.InteropServices
Imports iMon.DisplayApi
Imports System.Text

#End Region

'The interop services allow the plugin to be registered with a CLSID so Media Center
'Can find it
'The Prog ID must match with that in the registry in order for 
'MC to be able to pick up the plugin
<System.Runtime.InteropServices.ProgId("MCPlugin.ImonVFD")> _
Public Class MainInterface
#Region "Private Attributes"
    'This is the Interface to Media Center
    'This is set when Media Center calls the Init Method  
    Private WithEvents mediaCenterRef As mediacenter.MCAutomation
#End Region

#Region "Media Center Initialisation"
    ' <summary>
    ' After the plugin has been created Media Center 
    ' will call the following method, giving us a reference
    ' to the Media Center interface.
    ' </summary>
    ' <param name="mediaCenterReference">
    ' Media Center Reference
    ' </param>        
    Public Sub init(ByVal mediaCenterRef As mediacenter.MCAutomation)
        Try
            Me.mediaCenterRef = mediaCenterRef
            imon.Initialize()
            UpdateOnPlayerStateChange()
        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString)
        End Try
    End Sub
#End Region
#Region "EventStuff"
    Private _RelayEvent As RelayEvent
    Delegate Sub RelayEvent(ByVal EventData1 As String, ByVal EventData2 As String, ByVal EventData3 As String)
    Private Sub MyRelayEvent(ByVal EventData1 As String, ByVal EventData2 As String, ByVal EventData3 As String)
        Select Case (EventData1)
            Case "MJEvent type: MCCommand"
                Select Case (EventData2)
                    Case "MCC: NOTIFY_TRACK_CHANGE"
                        Dim objFile As mediacenter.IMJFileAutomation
                        objFile = CurrentTrack()
                        If Not objFile Is Nothing Then
                            If chkPos.Checked = True Then
                                Display("", "POSITION")
                            Else
                                Display()
                            End If
                        End If
                    Case "MCC: NOTIFY_PLAYER_STATE_CHANGE"
                        UpdateOnPlayerStateChange()
                    Case Else
                        UpdateOnPlayerStateChange()
                End Select
        End Select
        Application.DoEvents()
    End Sub
    Public Sub MC_FireMJEvent(ByVal s0 As String, ByVal s1 As String, ByVal s2 As String) Handles mediaCenterRef.FireMJEvent
        _RelayEvent = New RelayEvent(AddressOf MyRelayEvent)
        BeginInvoke(_RelayEvent, s0, s1, s2)
    End Sub

    Protected Overrides Sub Finalize()
        imon.Uninitialize()
        MyBase.Finalize()
    End Sub

    Private Sub UpdateOnPlayerStateChange()
        Dim objFile As mediacenter.IMJFileAutomation

        objFile = CurrentTrack()
        If Not objFile Is Nothing Then
            Select Case mediaCenterRef.GetPlayback().State
                Case mediacenter.MJPlaybackStates.PLAYSTATE_STOPPED
                    Display("- STOPPED - ")
                Case mediacenter.MJPlaybackStates.PLAYSTATE_PLAYING
                    If chkPos.Checked = True Then
                        Display("", "POSITION")
                    Else
                        Display()
                    End If
                Case mediacenter.MJPlaybackStates.PLAYSTATE_PAUSED
                    Display("Player is", "paused")
                Case Else
                    Display("- STOPPED - ")
            End Select
        End If
    End Sub
    Public ReadOnly Property CurrentTrack As mediacenter.IMJFileAutomation
        Get
            Dim playlist As mediacenter.IMJCurPlaylistAutomation
            playlist = mediaCenterRef.GetCurPlaylist
            If Not playlist Is Nothing Then
                Return playlist.GetFile(playlist.Position)
            Else
                Return Nothing
            End If
        End Get
    End Property

#End Region
#Region "Imon-Stuff"
    Dim WithEvents imon As iMonWrapperApi = New iMonWrapperApi()
    Private Sub wrapperApi_StateChanged(ByVal sender As Object, ByVal e As iMonStateChangedEventArgs) Handles imon.StateChanged
        Try
            If (e.IsInitialized) Then
                'now you can use the display but check iMonWrapperApi.DisplayType to see what display type you have available 
                'MsgBox("Display " & imon.DisplayType & " is initialized")
                imon.VFD.SetText("   Welcome to", "IMON VFD Plugin")
            Else
                'now the display is uninitialized and you can't use it anymore 
                'MsgBox("The display is now unititalized")
                lblErrtitle.Text = "wrapperAPI_StateChanged: IsInitialized"
                lblErrText.Text = "Display is not initialized"
            End If
        Catch ex As Exception
            lblErrtitle.Text = "wrapperAPI_StateChanged"
            lblErrText.Text = ex.Message.ToString
        End Try

    End Sub
    Private Sub wrapperApi_Error(ByVal sender As Object, ByVal e As iMonErrorEventArgs) Handles imon.Error
        'check e.Type to find out what kind of error occured
        Try
            lblErrtitle.Text = "wrapperAPI_Eror"
            lblErrText.Text = e.Type.ToString()
        Catch ex As Exception
            lblErrtitle.Text = "wrapperAPI_Eror"
            lblErrText.Text = ex.Message.ToString
        End Try
    End Sub
#End Region

    Dim vfd(1) As Lines
    Public Sub New()

        ' Dieser Aufruf ist für den Designer erforderlich.
        InitializeComponent()
    End Sub



    Private Sub MainInterface_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'lstLine1.SelectedIndex = My.Settings.Line1
        'lstLine2.SelectedIndex = My.Settings.Line2
        Dim i As Integer
        i = My.Settings.LB1
        If i And 1 Then
            lstLine1.SetSelected(0, True)
        End If
        If i And 2 Then
            lstLine1.SetSelected(1, True)
        End If
        If i And 4 Then
            lstLine1.SetSelected(2, True)
        End If
        If i And 8 Then
            lstLine1.SetSelected(3, True)
        End If
        If i And 16 Then
            lstLine1.SetSelected(4, True)
        End If
        If i And 32 Then
            lstLine1.SetSelected(5, True)
        End If
        If i And 64 Then
            lstLine1.SetSelected(6, True)
        End If
        If i And 128 Then
            lstLine1.SetSelected(7, True)
        End If
        If i And 256 Then
            lstLine1.SetSelected(8, True)
        End If
        i = My.Settings.LB2
        If i And 1 Then
            lstLine2.SetSelected(0, True)
        End If
        If i And 2 Then
            lstLine2.SetSelected(1, True)
        End If
        If i And 4 Then
            lstLine2.SetSelected(2, True)
        End If
        If i And 8 Then
            lstLine2.SetSelected(3, True)
        End If
        If i And 16 Then
            lstLine2.SetSelected(4, True)
        End If
        If i And 32 Then
            lstLine2.SetSelected(5, True)
        End If
        If i And 64 Then
            lstLine2.SetSelected(6, True)
        End If
        If i And 128 Then
            lstLine2.SetSelected(7, True)
        End If
        If i And 256 Then
            lstLine2.SetSelected(8, True)
        End If
        nudScrollSpeed.Value = My.Settings.Speed
        chkScrolling.Checked = My.Settings.Scrolling
        chkPos.Checked = My.Settings.Position
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim i As Integer
        Dim str_item As String
        i = 0
        For Each str_item In lstLine1.SelectedItems
            Select Case str_item
                Case "Album"
                    i = i + 1
                Case "Artist"
                    i = i + 2
                Case "Bitrate"
                    i = i + 4
                Case "Duration"
                    i = i + 8
                Case "File type"
                    i = i + 16
                Case "Last played"
                    i = i + 32
                Case "Title"
                    i = i + 64
                Case "Year"
                    i = i + 128
                Case "Samplerate"
                    i = i + 256
            End Select
        Next
        My.Settings.LB1 = i
        i = 0
        For Each str_item In lstLine2.SelectedItems
            Select Case str_item
                Case "Album"
                    i = i + 1
                Case "Artist"
                    i = i + 2
                Case "Bitrate"
                    i = i + 4
                Case "Duration"
                    i = i + 8
                Case "File type"
                    i = i + 16
                Case "Last played"
                    i = i + 32
                Case "Title"
                    i = i + 64
                Case "Year"
                    i = i + 128
                Case "Samplerate"
                    i = i + 256
            End Select
        Next
        My.Settings.LB2 = i
        My.Settings.Speed = nudScrollSpeed.Value
        My.Settings.Scrolling = chkScrolling.Checked
        My.Settings.Position = chkPos.Checked
        My.Settings.Save()
        UpdateOnPlayerStateChange()
    End Sub

    Private Sub Display(Optional ByVal pLine1 As String = "", Optional ByVal pLine2 As String = "")
        Dim strLine1 As String = "init"
        Dim strLine2 As String = "init"
        If pLine1 <> "" Then
            strLine1 = pLine1
        Else
            SetLine(strLine1, lstLine1)
        End If
        vfd(0) = New Lines
        vfd(0).Line = strLine1
        Timer1.Stop()
        If pLine2 <> "" Then
            If pLine2 = "POSITION" Then
                Timer1.Start()
                strLine2 = ""
            Else
                strLine2 = pLine2
            End If
        Else
            SetLine(strLine2, lstLine2)
        End If
        vfd(1) = New Lines
        vfd(1).Line = strLine2
        Try
            If imon.IsInitialized Then
                imon.VFD.SetText(vfd(0).ScrollLine.ToString, vfd(1).ScrollLine.ToString)
                lblErrtitle.Text = ""
                lblErrText.Text = ""
            Else
                lblErrtitle.Text = "Sub Display"
                lblErrText.Text = "IMON is not initialized"
            End If
        Catch ex As Exception
            lblErrtitle.Text = "Sub Display()"
            lblErrText.Text = ex.Message.ToString
        End Try
        lblLine1.Text = vfd(0).ScrollLine : lblLine1.Refresh()
        lblLine2.Text = vfd(1).ScrollLine : lblLine2.Refresh()
    End Sub
    Private Sub SetLine(ByRef line As String, ByRef lst As System.Windows.Forms.ListBox)
        Dim objFile As mediacenter.IMJFileAutomation
        Dim str_item As String
        Dim i As Integer
        Try
            objFile = CurrentTrack()
        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString)
            Exit Sub
        End Try
        line = ""
        Try
            For Each str_item In lst.SelectedItems
                'Select Case lst.SelectedItem.ToString
                Select Case str_item
                    Case "Artist"
                        If i >= 1 Then line = line & " - "
                        line = line & objFile.Artist
                        i = i + 1
                    Case "Title"
                        If i >= 1 Then line = line & " - "
                        line = line & objFile.Name
                        i = i + 1
                    Case "Album"
                        If i >= 1 Then line = line & " - "
                        line = line & objFile.Album
                        i = i + 1
                    Case "Year"
                        If i >= 1 Then line = line & " - "
                        line = line & "Recorded " & objFile.Year
                        i = i + 1
                    Case "Last played"
                        If i >= 1 Then line = line & " - "
                        line = line & "last " & objFile.GetFormattedLastPlayed
                        i = i + 1
                    Case "Bitrate"
                        If i >= 1 Then line = line & " - "
                        line = line & "Bitrate: " & objFile.Bitrate
                        i = i + 1
                    Case "Duration"
                        If i >= 1 Then line = line & " - "
                        line = line & "Duration: " & objFile.GetFormattedDuration
                        i = i + 1
                    Case "File Type"
                        If i >= 1 Then line = line & " - "
                        line = line & "Filetype: " & objFile.Filetype
                        i = i + 1
                    Case "Samplerate"
                        If i >= 1 Then line = line & " - "
                        line = line & "Samplerate: " & mediaCenterRef.GetPlayback.Samplerate
                        i = i + 1
                End Select
                If line.ToString.Length > 16 Then
                    line = line & "   "
                End If
            Next
        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString)
        End Try
    End Sub


    Private Sub timScrolling_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles timScrolling.Tick
        vfd(0).Scroll_new()
        vfd(1).Scroll_new()
        lblLine1.Text = vfd(0).ScrollLine : lblLine1.Refresh()
        lblLine2.Text = vfd(1).ScrollLine : lblLine2.Refresh()
        Try
            If imon.IsInitialized Then
                imon.VFD.SetText(vfd(0).ScrollLine, vfd(1).ScrollLine)
                lblErrtitle.Text = ""
                lblErrText.Text = ""
            Else
                lblErrtitle.Text = "Sub Display"
                lblErrText.Text = "TicK: IMON is not initialized"
            End If
        Catch ex As Exception
            lblErrtitle.Text = "Sub timScrolling"
            lblErrText.Text = ex.Message.ToString
        End Try
    End Sub

    Private Sub chkScrolling_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkScrolling.CheckedChanged
        If chkScrolling.Checked Then
            timScrolling.Interval = nudScrollSpeed.Value
            timScrolling.Start()
            nudScrollSpeed.Enabled = True
        Else
            timScrolling.Stop()
            vfd(0).ResetScroll()
            vfd(1).ResetScroll()
            nudScrollSpeed.Enabled = False
        End If
    End Sub

    Private Sub MainInterface_Load_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    Private Sub nudScrollSpeed_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles nudScrollSpeed.ValueChanged
        timScrolling.Interval = nudScrollSpeed.Value
    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Dim dur As Integer
        Dim pos As Integer
        Dim play As mediacenter.IMJPlaybackAutomation
        Dim x As Integer
        Dim strOut As New StringBuilder
        play = mediaCenterRef.GetPlayback
        Try
            dur = play.Duration
            pos = play.Position
            x = CInt((32 * pos) / dur)
            ' ''If x > 0 Then
            ' ''    If x = 1 Then
            ' ''        strOut.Append(">")
            ' ''    ElseIf x Mod 2 = 0 Then
            ' ''            strOut.Insert(0, "-", x \ 2)
            ' ''    Else
            ' ''            strOut.Insert(0, "-", x \ 2).Append("-")
            ' ''    End If
            ' ''End If
            If Not play Is Nothing Then
                Dim tsPos As TimeSpan = Now.AddSeconds(pos).Subtract(Now)
                Dim tsDur As TimeSpan = Now.AddSeconds(dur).Subtract(Now)
                If tsDur.Seconds > 3599 Then
                    vfd(1).Line = "    " & Format(CDate(tsPos.ToString), "hh:mm:ss") '& " / " & Format(CDate(tsDur.ToString), "hh:mm:ss")
                Else
                    vfd(1).Line = "  " & Format(CDate(tsPos.ToString), "mm:ss") & " / " & Format(CDate(tsDur.ToString), "mm:ss")
                End If
            End If
        Catch ex As Exception
            'we'll do nothing about that
        End Try
    End Sub
End Class
Public Class Lines
    Private iLen As Integer
    Private strLine As String
    Private strScroll As String
    Private iScrollStart As Integer = 1
    Private iLenSub1 As Integer = 15
    Private iLenSub2 As Integer = 1
    Public ReadOnly Property Len As Integer
        Get
            Len = iLen
        End Get
    End Property
    Public Property Line As String
        Get
            Line = strLine
        End Get
        Set(ByVal value As String)
            strLine = value
            iLen = strLine.ToString.Length
            ScrollLine = strLine
        End Set
    End Property
    Public Property ScrollLine As String
        Get
            ScrollLine = strScroll
        End Get
        Private Set(ByVal value As String)
            strScroll = value
        End Set
    End Property
    Public Sub Scroll()
        If Len > 16 Then
            If iScrollStart + 16 > Len + 1 Then
                iScrollStart = 1
            End If
            ScrollLine = Me.Line.ToString.Substring(iScrollStart - 1, 16)
            iScrollStart = iScrollStart + 1
        Else
            ScrollLine = Line
        End If
    End Sub
    Public Function Scroll_new() As Boolean
        Dim bSwitchLine As Boolean = False
        If Len > 16 Then
            If iScrollStart <= Len Then
                If iScrollStart + 16 > Len + 1 Then  'Commencer coupure maintenant
                    ScrollLine = Me.Line.ToString.Substring(iScrollStart - 1, iLenSub1) + Me.Line.ToString.Substring(0, iLenSub2)
                    iLenSub1 = iLenSub1 - 1
                    iLenSub2 = iLenSub2 + 1
                Else
                    ScrollLine = Me.Line.ToString.Substring(iScrollStart - 1, 16)
                End If
            Else
                ScrollLine = Me.Line.ToString.Substring(0, 16)
                iScrollStart = 1
                iLenSub1 = 15
                iLenSub2 = 1
                bSwitchLine = True
            End If
            iScrollStart = iScrollStart + 1
        Else
            ScrollLine = Line
        End If
        Return bSwitchLine
    End Function
    Public Sub ResetScroll()
        ScrollLine = Line
    End Sub
End Class
